struct nlist; struct exec; struct mlist;
class SunosType;

class SunosSymTab : public SymTab {
protected:
	exec	*hdr;
	nlist	*base;
	long	symoff;
	DType	gatherdtype(nlist *);
	DType	chain(int, nlist *);
	void	gathervar(nlist*, Var**, Block*, UDisc);
	void	gathervar(nlist*, Var**, Block*, UDisc, SunosType*, char* =0);
	char	*gettbl();
	nlist	*nlistvector(long,long);
	Source	*tree();
	char	*gethdr();
	SunosTShare *sunosshare;
public:
		SunosSymTab(Core*,int,SymTab* =0,long=0);
		~SunosSymTab();
	Block	*gatherfunc(Func*);
	Var	*gatherutype(UType*);
};

typedef class DType *DTypep;
typedef DTypep *DTypepar;
class SunosTShare;

class SunosTFile {
	friend		SunosTShare;
	char		*fname;
	long		value;
	DTypepar	type;
	int		ntypes;
	int		highest;
};

class SunosTShare {
	friend		SunosType;
	int		used;
	int		nfiles;
	SunosTFile	*file;
	int		findfile(char*, long);
	DType		*findtype(int,int);
	char		*filename(int);
	void		entertype(int, int, DTypep);
	int		addfile(char*, long=0);
public:
			~SunosTShare();
			SunosTShare();
};

class SunosType {
	int		utypeindex;
	Source		*src;
	int		*filemap;
	int		nfiles;
	int		used;
	SunosTShare	*share;
public:
	void		addinclude(char*, int, long);
	char		*backtypeindex(char*);
	DType		chain(DType*);
	DType		gettype(int, int);
	DType		gettype(char*);
	void 		parsetype(char*, char*);
	char		*toindices(char*, int&, int&);
	char		*toint(char*, int&);
	char		*toutypestr(char*, int);
			~SunosType();
			SunosType(Source*, SunosTShare*);
};

class SunosSource : public Source {
public:
			SunosSource(SymTab*,Source*,char*,long);
			~SunosSource();
	SunosType	*typeinfo;
	int		suncc;
	long		datastart;
	long		bssstart;
};

class SunosUType : public UType {
public:
			SunosUType(SymTab*,char*,char*);
			~SunosUType();
	char		*encode;
};
